package com.trafficparrot.examples.http;

import com.trafficparrot.examples.tools.http.HttpClient;
import org.junit.Test;

import java.io.IOException;

import static java.lang.System.lineSeparator;
import static org.assertj.core.api.Assertions.assertThat;

public class ImportedMappingsIntegrationTest {

    private final HttpClient httpClient = new HttpClient("http://localhost:18081");

    @Test(timeout = 30_000)
    public void jsonExample() throws IOException {
        httpClient.displayHttpMappingsContaining("listVersionsv2");

        String response = httpClient.get("/listVersionsv2");

        assertThat(response).isEqualTo("{" + lineSeparator() +
                "  \"versions\" : [ {" + lineSeparator() +
                "    \"status\" : \"CURRENT\"," + lineSeparator() +
                "    \"updated\" : \"2011-01-21T11:33:21Z\"," + lineSeparator() +
                "    \"id\" : \"v2.0\"," + lineSeparator() +
                "    \"links\" : [ {" + lineSeparator() +
                "      \"href\" : \"http://127.0.0.1:8774/v2/\"," + lineSeparator() +
                "      \"rel\" : \"self\"" + lineSeparator() +
                "    } ]" + lineSeparator() +
                "  }, {" + lineSeparator() +
                "    \"status\" : \"EXPERIMENTAL\"," + lineSeparator() +
                "    \"updated\" : \"2013-07-23T11:33:21Z\"," + lineSeparator() +
                "    \"id\" : \"v3.0\"," + lineSeparator() +
                "    \"links\" : [ {" + lineSeparator() +
                "      \"href\" : \"http://127.0.0.1:8774/v3/\"," + lineSeparator() +
                "      \"rel\" : \"self\"" + lineSeparator() +
                "    } ]" + lineSeparator() +
                "  } ]" + lineSeparator() +
                "}");
    }

    @Test(timeout = 30_000)
    public void xmlExample() throws IOException {
        httpClient.displayHttpMappingsContaining("/ibmMq/record");

        String response = httpClient.post("/ibmMq/record", "");

        assertThat(response).isEqualTo("<ApiResponse><status>ON</status><flash><success>Started</success></flash></ApiResponse>");
    }

    @Test(timeout = 30_000)
    public void simpleDynamicJsonExample() throws IOException {
        httpClient.displayHttpMappingsContaining("/simpleDynamicJson");

        String response = httpClient.post("/simpleDynamicJson", "{\n" +
                "    \"name\": \"example-name\"\n" +
                "}");

        assertThat(response).isEqualToIgnoringWhitespace("{\n" +
                "  \"response\" : \"example-name\"\n" +
                "}");
    }

    @Test(timeout = 30_000)
    public void escapedDynamicJsonExample() throws IOException {
        httpClient.displayHttpMappingsContaining("/escapedDynamicJson");

        String response = httpClient.post("/escapedDynamicJson", "{\n" +
                "    \"type\": \"request\",\n" +
                "    \"items\": [\n" +
                "        { \"id\": 1 },\n" +
                "        { \"id\": 2 },\n" +
                "        { \"id\": 3 }\n" +
                "    ]\n" +
                "}");

        assertThat(response).isEqualToIgnoringWhitespace("{\n" +
                "    \"type\": \"response\",\n" +
                "    \"items\": [\n" +
                "        { \"id\": 1, \"status\": \"OK\" },\n" +
                "        { \"id\": 2, \"status\": \"OK\" },\n" +
                "        { \"id\": 3, \"status\": \"OK\" }\n" +
                "    ]\n" +
                "}");
    }

    @Test(timeout = 30_000)
    public void dynamicXmlExample() throws IOException {
        httpClient.displayHttpMappingsContaining("/escapedDynamicXml");

        String response = httpClient.post("/escapedDynamicXml", "<request>\n" +
                "    <item id=\"1\"/>\n" +
                "    <item id=\"2\"/>\n" +
                "    <item id=\"3\"/>\n" +
                "</request>");

        assertThat(response).isEqualToIgnoringWhitespace("<response>\n" +
                "    <item id=\"1\" status=\"OK\"/>\n" +
                "    <item id=\"2\" status=\"OK\"/>\n" +
                "    <item id=\"3\" status=\"OK\"/>\n" +
                "</response>");
    }
}
