package com.trafficparrot.examples.hello.ibmmq;

import com.ibm.mq.MQException;
import org.assertj.core.api.Assertions;
import org.junit.Test;

import java.io.IOException;

public class HelloWorldIbmMqQueueIntegrationTest {
    private final IbmMqClient ibmMqClient = new IbmMqClient();

    @Test(timeout = 30_000)
    public void helloWorldIbmMqQueue() throws IOException, MQException {
        ibmMqClient.sendIbmMqMessageToQueue("DEV.REQUEST.QUEUE", "hello");

        String response = ibmMqClient.receiveIbmMqMessageFromQueue("DEV.RESPONSE.QUEUE");

        Assertions.assertThat(response).isEqualTo("world");
    }
}
