package com.trafficparrot.examples.http;

import com.trafficparrot.examples.tools.http.HttpClient;
import org.junit.Test;

import java.io.IOException;

import static org.assertj.core.api.Assertions.assertThat;


public class DataLookupIntegrationTest {
    private final HttpClient httpClient = new HttpClient("http://localhost:18081");

    @Test
    public void lookupUsingRequestData() throws IOException {
        httpClient.displayHttpMappingsContaining("isoCountryCodes");

        // This corresponds to the 100,ES row in isoCountryCodes.csv
        String example1 = httpClient.post("/isoCountryCodes", "{\n" +
                "    \"internalCode\": 100\n" +
                "}");
        assertThat(example1).isEqualToIgnoringWhitespace("{\n" +
                "    \"internalCode\": 100,\n" +
                "    \"isoCountryCode\": \"ES\"\n" +
                "}");

        // This corresponds to the 300,TW row in isoCountryCodes.csv
        String example2 = httpClient.post("/isoCountryCodes", "{\n" +
                "    \"internalCode\": 300\n" +
                "}");
        assertThat(example2).isEqualToIgnoringWhitespace("{\n" +
                "    \"internalCode\": 300,\n" +
                "    \"isoCountryCode\": \"TW\"\n" +
                "}");

        // This shows the default parameter being used when no row matches
        String example3 = httpClient.post("/isoCountryCodes", "{\n" +
                "    \"internalCode\": 999\n" +
                "}");
        assertThat(example3).isEqualToIgnoringWhitespace("{\n" +
                "    \"internalCode\": 999,\n" +
                "    \"isoCountryCode\": \"default\"\n" +
                "}");
    }
}
