package com.trafficparrot.examples.http;

import com.trafficparrot.examples.tools.http.HttpClient;
import org.junit.Test;

import java.io.IOException;

import static org.assertj.core.api.Assertions.assertThat;


public class MathIntegrationTest {
    private final HttpClient httpClient = new HttpClient("http://localhost:18081");

    @Test
    public void lookupUsingRequestData() throws IOException {
        httpClient.displayHttpMappingsContaining("sales.csv");

        // This corresponds to the 1,1,2.50 row in sales.csv
        String example1 = httpClient.post("/sales", "{\n" +
                "    \"id\": 1\n" +
                "}");
        assertThat(example1).isEqualToIgnoringWhitespace("{\n" +
                "    \"id\": 1,\n" +
                "    \"total\": 2.50\n" +
                "}");

        // This corresponds to the 3,5,8.00 row in sales.csv
        String example2 = httpClient.post("/sales", "{\n" +
                "    \"id\": 3\n" +
                "}");
        assertThat(example2).isEqualToIgnoringWhitespace("{\n" +
                "    \"id\": 3,\n" +
                "    \"total\": 40.00\n" +
                "}");
    }
}
