package com.trafficparrot.examples.jms;

import com.trafficparrot.examples.tools.jms.JmsClient;
import com.trafficparrot.examples.tools.jms.WaitForOneJmsMessage;
import org.junit.After;
import org.junit.Test;

import javax.jms.JMSException;
import java.time.Duration;

import static org.assertj.core.api.Assertions.assertThat;

public class HelloWorldJmsTopicIntegrationTest {
    private final JmsClient jmsClient = new JmsClient("tcp://localhost:19091");
    private WaitForOneJmsMessage waitForOneJmsMessage;

    @Test(timeout = 30_000)
    public void helloWorldJmsTopic() throws JMSException, InterruptedException {
        waitForOneJmsMessage = jmsClient.listenOnTopic("response.topic.text");
        jmsClient.sendTextMessageToTopic("request.topic.text", "hello");

        String response = waitForOneJmsMessage.awaitMessage();

        assertThat(response).isEqualTo("world");
    }

    @Test(timeout = 30_000)
    public void helloWorldJmsTopicWithFixedDelay() throws JMSException, InterruptedException {
        waitForOneJmsMessage = jmsClient.listenOnTopic("response.topic.text");

        jmsClient.sendTextMessageToTopic("request.topic.text", "hello-delay");

        long start = System.nanoTime();
        String response = waitForOneJmsMessage.awaitMessage();
        long end = System.nanoTime();

        assertThat(response).isEqualTo("world-delay");
        assertThat(Duration.ofNanos(end - start)).isGreaterThanOrEqualTo(Duration.ofSeconds(1));
    }

    @After
    public void tearDown() throws JMSException {
        if (waitForOneJmsMessage != null) {
            waitForOneJmsMessage.close();
        }
    }
}
