/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.file;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.trafficparrot.sdk.file.FileMessage;
import com.trafficparrot.sdk.file.FileMessageResponse;
import com.trafficparrot.sdk.internal.RenderableInUI;
import com.trafficparrot.sdk.jms.Destination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileMessageResponseTransformer
implements RenderableInUI {
    protected final Logger logger;

    public FileMessageResponseTransformer() {
        this(LoggerFactory.getLogger(FileMessageResponseTransformer.class));
    }

    public FileMessageResponseTransformer(Logger logger) {
        this.logger = logger;
    }

    public final FileMessageResponse transform(Destination requestDestination, FileMessage requestMessage, FileMessageResponse response, Parameters parameters) {
        try {
            FileMessageResponse fileMessageResponse = this.doTransform(requestDestination, requestMessage, response, parameters);
            if (!"NO_TRANSFORMER".equals(fileMessageResponse.fileMessageResponseTransformerClassName)) {
                String errorMessage = String.format("Please set the fileMessageResponseTransformerClassName to %s in %s (it was set to %s)", "NO_TRANSFORMER", this.getClass().getCanonicalName(), fileMessageResponse.fileMessageResponseTransformerClassName);
                this.logger.error(errorMessage);
                return new FileMessageResponse(response.destination, response.fileName, errorMessage);
            }
            return fileMessageResponse;
        }
        catch (Exception e) {
            String errorMessage = String.format("%s had a problem while transforming: %s", this.getClass().getCanonicalName(), e.getMessage());
            this.logger.error(errorMessage, (Throwable)e);
            return new FileMessageResponse(response.destination, response.fileName, errorMessage + ". See logs for more details.");
        }
    }

    @Deprecated
    protected FileMessageResponse doTransform(Destination requestDestination, FileMessage requestMessage, FileMessageResponse response) throws Exception {
        throw new IllegalStateException(this.getDisplayName() + " must implement doTransform");
    }

    protected FileMessageResponse doTransform(Destination requestDestination, FileMessage requestMessage, FileMessageResponse response, Parameters parameters) throws Exception {
        return this.doTransform(requestDestination, requestMessage, response);
    }

    @Override
    public String getDisplayName() {
        return this.getClass().getSimpleName();
    }
}

