/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.ibmmq;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import com.ibm.mq.MQMessage;
import com.trafficparrot.sdk.ibmmq.DestinationLookup;
import com.trafficparrot.sdk.ibmmq.IbmMqMessageFormat;
import com.trafficparrot.sdk.internal.encoding.PrintableCharactersRepresentation;
import com.trafficparrot.sdk.jms.Destination;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class IbmMqResponse
implements Comparable<IbmMqResponse> {
    public static final String NO_TRANSFORMER = "NO_TRANSFORMER";
    private static final int UTF8 = 1208;
    public final Destination destination;
    public final String ibmMqResponseTransformerClassName;
    public final IbmMqMessageFormat format;
    public final String text;
    public final long fixedDelayMilliseconds;
    public final Optional<DestinationLookup> destinationLookup;
    public final transient Optional<MQMessage> responseMessage;

    public IbmMqResponse(@JsonProperty(value="destination") Destination destination, @JsonProperty(value="ibmMqResponseTransformerClassName") String ibmMqResponseTransformerClassName, @JsonProperty(value="format") IbmMqMessageFormat format, @JsonProperty(value="text") String text, @JsonProperty(value="fixedDelayMilliseconds") Long fixedDelayInMilliseconds, @JsonProperty(value="destinationLookup") Optional<DestinationLookup> destinationLookup, @JsonProperty(value="never-serialized-field") Optional<MQMessage> responseMessage) {
        this.destination = destination;
        this.ibmMqResponseTransformerClassName = ibmMqResponseTransformerClassName;
        this.format = (IbmMqMessageFormat)((Object)ObjectUtils.firstNonNull((Object[])new IbmMqMessageFormat[]{format, IbmMqMessageFormat.MQFMT_STRING}));
        this.text = text;
        this.fixedDelayMilliseconds = (Long)ObjectUtils.firstNonNull((Object[])new Long[]{fixedDelayInMilliseconds, 0L});
        this.destinationLookup = destinationLookup;
        this.responseMessage = responseMessage;
    }

    public IbmMqResponse(Destination destination, String text) {
        this(destination, NO_TRANSFORMER, IbmMqMessageFormat.MQFMT_STRING, text, 0L, Optional.of(DestinationLookup.USE_REQUEST_MESSAGE_REPLY_TO_QUEUE_NAME_OR_MAPPING_RESPONSE_DESTINATION), Optional.empty());
    }

    public IbmMqResponse(Destination destination, MQMessage responseMessage, long fixedDelayMilliseconds, Optional<DestinationLookup> destinationLookup) {
        this(destination, NO_TRANSFORMER, null, null, fixedDelayMilliseconds, destinationLookup, Optional.of(responseMessage));
    }

    public MQMessage createMessage(byte[] correlationId, String replyToQueueManagerNameHeader, String replyToQueueNameHeader) throws IOException {
        if (this.responseMessage.isPresent()) {
            return this.responseMessage.get();
        }
        MQMessage mqMessage = new MQMessage();
        this.createMessage(mqMessage, correlationId, replyToQueueManagerNameHeader, replyToQueueNameHeader);
        return mqMessage;
    }

    @VisibleForTesting
    void createMessage(MQMessage mqMessage, byte[] correlationId, String replyToQueueManagerName, String replyToQueueName) throws IOException {
        mqMessage.correlationId = correlationId;
        mqMessage.replyToQueueManagerName = replyToQueueManagerName;
        mqMessage.replyToQueueName = replyToQueueName;
        mqMessage.format = this.format.value;
        IbmMqResponse.writeMessage(mqMessage, this.format, this.text);
    }

    public static void writeMessage(MQMessage mqMessage, IbmMqMessageFormat format, String text) throws IOException {
        switch (format) {
            case MQFMT_RF_HEADER_1: 
            case MQFMT_RF_HEADER_2: 
            case MQFMT_NONE: {
                mqMessage.write(PrintableCharactersRepresentation.decodePrintableCharacters(text));
                break;
            }
            case MQFMT_STRING: {
                mqMessage.characterSet = 1208;
                mqMessage.writeString(text);
            }
        }
    }

    public boolean useDefaultDestinationLookup() {
        return !this.destinationLookup.isPresent() || this.destinationLookup.get().isDefault();
    }

    public boolean forceMappingDestinationLookup() {
        return this.destinationLookup.isPresent() && this.destinationLookup.get() == DestinationLookup.USE_MAPPING_RESPONSE_DESTINATION;
    }

    public boolean hasTransformer() {
        return StringUtils.isNotBlank((CharSequence)this.ibmMqResponseTransformerClassName) && !NO_TRANSFORMER.equals(this.ibmMqResponseTransformerClassName);
    }

    @JsonIgnore
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public int compareTo(IbmMqResponse other) {
        return ComparisonChain.start().compare((Comparable)this.destination, (Comparable)other.destination).compare((Comparable)((Object)this.text), (Comparable)((Object)other.text)).result();
    }
}

