/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.ibmmq;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.ibm.mq.MQMessage;
import com.trafficparrot.sdk.ibmmq.IbmMqResponse;
import com.trafficparrot.sdk.internal.RenderableInUI;
import com.trafficparrot.sdk.jms.Destination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IbmMqResponseTransformer
implements RenderableInUI {
    protected final Logger logger;

    public IbmMqResponseTransformer() {
        this(LoggerFactory.getLogger(IbmMqResponseTransformer.class));
    }

    public IbmMqResponseTransformer(Logger logger) {
        this.logger = logger;
    }

    public final IbmMqResponse transform(Destination requestDestination, MQMessage requestMessage, IbmMqResponse response, Parameters parameters) {
        try {
            IbmMqResponse ibmMqResponse = this.doTransform(requestDestination, requestMessage, response, parameters);
            if (!"NO_TRANSFORMER".equals(ibmMqResponse.ibmMqResponseTransformerClassName)) {
                String errorMessage = String.format("Please set the ibmMqResponseTransformerClassName to %s in %s (it was set to %s)", "NO_TRANSFORMER", this.getClass().getCanonicalName(), ibmMqResponse.ibmMqResponseTransformerClassName);
                this.logger.error(errorMessage);
                return new IbmMqResponse(response.destination, errorMessage);
            }
            return ibmMqResponse;
        }
        catch (Exception e) {
            String errorMessage = String.format("%s had a problem while transforming: %s", this.getClass().getCanonicalName(), e.getMessage());
            this.logger.error(errorMessage, (Throwable)e);
            return new IbmMqResponse(response.destination, errorMessage + ". See logs for more details.");
        }
    }

    @Deprecated
    protected IbmMqResponse doTransform(Destination requestDestination, MQMessage requestMessage, IbmMqResponse response) throws Exception {
        throw new IllegalStateException(this.getDisplayName() + " must implement doTransform");
    }

    protected IbmMqResponse doTransform(Destination requestDestination, MQMessage requestMessage, IbmMqResponse response, Parameters parameters) throws Exception {
        return this.doTransform(requestDestination, requestMessage, response);
    }

    @Override
    public String getDisplayName() {
        return this.getClass().getSimpleName();
    }
}

