/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.internal.encoding;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Bytes;
import com.trafficparrot.sdk.internal.encoding.FindAndReplaceBytes;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.CharUtils;

public class PrintableCharactersRepresentation {
    private static final String NEGATIVE_BYTE_ESCAPE = "\b-";
    private static final byte[] NEGATIVE_BYTE_ESCAPE_BYTES = "\b-".getBytes(StandardCharsets.UTF_8);
    private static final int MAKE_POSITIVE_OFFSET = 128;

    public static String encodePrintableCharacters(byte[] bytesToEncode) {
        byte[] encoded = new byte[bytesToEncode.length + PrintableCharactersRepresentation.numberOfNegativeBytes(bytesToEncode) * NEGATIVE_BYTE_ESCAPE_BYTES.length];
        int position = 0;
        for (byte toEncode : bytesToEncode) {
            if (toEncode >= 0) {
                encoded[position++] = toEncode;
                continue;
            }
            for (byte escape : NEGATIVE_BYTE_ESCAPE_BYTES) {
                encoded[position++] = escape;
            }
            encoded[position++] = (byte)(toEncode + 128);
        }
        return new String(encoded, StandardCharsets.UTF_8);
    }

    public static byte[] decodePrintableCharacters(String text) {
        byte[] toDecode = text.getBytes(StandardCharsets.UTF_8);
        List<Integer> occurrences = FindAndReplaceBytes.findOccurrences(toDecode, NEGATIVE_BYTE_ESCAPE_BYTES);
        byte[][] pieces = new byte[occurrences.size() * 2 + 1][];
        int position = 0;
        for (int i = 0; i < occurrences.size(); ++i) {
            int occurrence = occurrences.get(i);
            byte[] before = Arrays.copyOfRange(toDecode, position, occurrence);
            pieces[2 * i] = before;
            byte b = toDecode[occurrence + NEGATIVE_BYTE_ESCAPE_BYTES.length];
            pieces[2 * i + 1] = new byte[]{(byte)(b - 128)};
            position = occurrence + NEGATIVE_BYTE_ESCAPE_BYTES.length + 1;
        }
        byte[] after = Arrays.copyOfRange(toDecode, position, toDecode.length);
        pieces[occurrences.size() * 2] = after;
        return Bytes.concat((byte[][])pieces);
    }

    public static boolean isMostlyPrintableCharacters(byte[] bytes, double mostlyPrintableThreshold) {
        return (double)PrintableCharactersRepresentation.numberOfPrintableCharacters(bytes) / (double)bytes.length > mostlyPrintableThreshold;
    }

    @VisibleForTesting
    static int numberOfPrintableCharacters(byte[] bytes) {
        String string = new String(bytes, StandardCharsets.UTF_8);
        int count = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            char character = string.charAt(i);
            if (!CharUtils.isAsciiPrintable((char)character) && !Character.isLetterOrDigit(character) && !Character.isWhitespace(character)) continue;
            ++count;
        }
        return count;
    }

    private static int numberOfNegativeBytes(byte[] bytes) {
        int count = 0;
        for (byte aByte : bytes) {
            if (aByte >= 0) continue;
            ++count;
        }
        return count;
    }
}

