package com.trafficparrot.sdk.example.handlebars;

import com.github.jknack.handlebars.Options;
import com.trafficparrot.sdk.handlebars.TrafficParrotHelper;

import java.util.concurrent.ThreadLocalRandom;

/**
 * This is how {{randomInteger}} is implemented in Traffic Parrot.
 */
public class RandomInteger extends TrafficParrotHelper<Object> {

    @Override
    public Integer doApply(Object lower, Options options) {
        return randomInteger(lower, options);
    }

    private int randomInteger(Object lower, Options options) {
        if (!(lower instanceof Integer)) {
            return ThreadLocalRandom.current().nextInt();
        }
        if (options.params.length == 0) {
            return ThreadLocalRandom.current().nextInt((int) lower, Integer.MAX_VALUE);
        }
        int upper = options.param(0);
        return ThreadLocalRandom.current().nextInt((int) lower, upper);
    }
}
