package com.trafficparrot.sdk.example.http;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.trafficparrot.sdk.http.HttpResponseDefinitionTransformer;

public class ValidatePasswordLength extends HttpResponseDefinitionTransformer {
    /**
     * Please note, a simpler way of implementing this behaviour
     * is to create a request-response mapping
     * that has a request password 10 characters long, for example
     * "01234567890" and then test the application with that password
     * instead of having to create a special extension.
     */
    @Override
    public ResponseDefinition doTransform(Request request, ResponseDefinition responseDefinition, FileSource fileSource, Parameters parameters) {
        if (request.getUrl().startsWith("/login")) {
            int passwordLength = request.queryParameter("password").firstValue().length();
            if (passwordLength < 8) {
                return new ResponseDefinitionBuilder()
                        .withStatus(400)
                        .withBody("Password to short " + passwordLength)
                        .build();
            } else {
                return new ResponseDefinitionBuilder()
                        .withStatus(200)
                        .withBody("Password length valid.")
                        .build();
            }
        }
        return responseDefinition;
    }

    @Override
    public String getName() {
        return getClass().getSimpleName();
    }
}
